﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;
using VIRP_WEB.Controls.Custom.BPR;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.BPR.QuestionTool
{
    public partial class ToolQuestionGroupEdit : BprBasePage
    {
        private ServiceInterfaceManager toolManager = new ServiceInterfaceManager();

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int formId = Request.QueryString["id"] == null ? 0 : Helpers.GetIntFromString(Request.QueryString["id"].ToString());
                HiddenFieldFormId.Value = formId.ToString();
                LabelBreadCrumb.Text = formId == 0 ? "<H1>Follow-up Question Tool >  Add Question Group</H1>" : "<H1>Follow-up Question Tool >  Edit Question Group</H1>";
                LoadBaseControls();
                LoadControlsFromObject(formId);
                if (formId == 0)
                {
                    ButtonSubmitQuestionGroup.Enabled = false;
                }
            }
        }

        private bool ValidateQuestionGroup(string formId)
        {
            bool result = true;
            string prefix = "Failed to submit question group. ";

            TOOL_FORM_DTO form = toolManager.GetFormById(Helpers.GetIntFromString(formId));
            if (form != null)
            {
                if (form.TOOL_FORM_QUESTIONs.Count() == 0)
                {
                    CustomValidatorSubmitQuestionGroup.ErrorMessage = prefix + "At least one question is required in the group.";
                    result = false;
                }
            }

            return result;
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxKeyWords.Text = "";
            DropDownListQuestionType.SelectedIndex = -1;
        }

        protected void ButtonSearch_Click(object sender, EventArgs e)
        {
            GridViewQuestions.DataBind();
        }

        protected void GridViewFormQuestions_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            try
            {
                int questionId = Convert.ToInt32(e.CommandArgument);

                switch (e.CommandName)
                {
                    case "RemoveFromGroup":
                        if (toolManager.RemoveQuestionFromForm(User.Identity.Name, questionId, Helpers.GetIntFromString(HiddenFieldFormId.Value)))
                        {
                            LoadBaseControls();
                            LoadControlsFromObject(Helpers.GetIntFromString(HiddenFieldFormId.Value));
                            Alert.ShowDeleteSuccessful();
                        }
                        else
                        {
                            LoadBaseControls();
                            Alert.ShowSaveFailed();
                        }
                        break;
                    case "Preview":
                        Response.Redirect("ToolQuestionPreview.aspx?id=" + questionId.ToString());
                        break;
                }
            }
            catch
            {
                //do nothing.
                // this is for sorting only.
            }

            GridViewFormQuestions.SelectedIndex = -1;
        }

        protected void GridViewQuestions_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            int saveStatus = 0;
            try
            {
                int questionId = Convert.ToInt32(e.CommandArgument);

                switch (e.CommandName)
                {
                    case "AddToGroup":
                        saveStatus = toolManager.AddQuestionToForm(User.Identity.Name, questionId, Helpers.GetIntFromString(HiddenFieldFormId.Value));
                        if (saveStatus == 2)
                        {
                            Alert.Show("This question already exists in the group!");
                        }
                        else if (saveStatus == 1)
                        {
                            LoadBaseControls();
                            LoadControlsFromObject(Helpers.GetIntFromString(HiddenFieldFormId.Value));
                            Alert.ShowSaveSuccess();
                        }
                        else
                        {
                            LoadBaseControls();
                            Alert.ShowSaveFailed();
                        }
                        break;
                    case "Preview":
                        Response.Redirect("ToolQuestionPreview.aspx?id=" + questionId.ToString());
                        break;
                }
            }
            catch
            {
                //do nothing.
                // this is for sorting only.
            }

            GridViewQuestions.SelectedIndex = -1;
        }

        protected void ButtonSubmitQuestionGroup_Click(object sender, EventArgs e)
        {
            CustomValidatorSubmitQuestionGroup.IsValid = true;
            SaveQuestionGroup();

            // Validate that at least one value was entered    
            if (ValidateQuestionGroup(HiddenFieldFormId.Value) == false)
            {
                CustomValidatorSubmitQuestionGroup.IsValid = false;
            }
            else
            {
                //submit the question            
                try
                {
                    int formId = Helpers.GetIntFromString(HiddenFieldFormId.Value);
                    //Add to Audit Log
                    //UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
                    string message = BaseControlTextboxFormName.Text;
                    Helpers.AddActivityToAuditLog(UserSession.CurrentUserId, User.Identity.Name, UserSession.CurrentRegistryId, message,
                        string.Empty, VIRP.AHOBPR.BO.AuditLogType.NewFollowupQuestionGroupSubmitted, null);

                    //int saveStatus = _toolManager.SubmitFollowUpFormToStdTables(formId);
                    toolManager.SubmitFollowUpFormToStdTables(User.Identity.Name, formId);
                    //if (saveStatus == 1)
                    //{
                        //clear view to run again to get newly added group in application dropdown displays
                        //AHOBPRGlobal.ViewLookupAll = null;

                        //if (ServiceCaller.CreateFollowupFormJson(formId.ToString(), HiddenFieldSystemWide.Value))
                        //{
                            formId = SubmitQuestionGroupAsComplete();
                            if (formId > 0)
                            {
                                ButtonSaveQuestionGroup.Enabled = false;
                                ButtonSubmitQuestionGroup.Enabled = false;
                                PanelEditFormQuestion.Enabled = false;
                                Alert.ShowSaveSuccess();
                                UserSession.BprFormId = string.Empty;
                            }
                            else
                            {
                                Alert.ShowSaveFailed();
                            }
                        //}
                        //else
                        //{
                        //    Alert.ShowSaveFailed();
                        //}
                    //}
                    //else
                    //{
                    //    Alert.ShowSaveFailed();
                    //}
                }
                catch
                {
                    Alert.ShowSaveFailed();
                }
            }
        }

        private int SaveQuestionGroup()
        {
            int formId = Helpers.GetIntFromString(HiddenFieldFormId.Value);

            TOOL_FORM_DTO saveForm = new TOOL_FORM_DTO();
            saveForm.NAME = BaseControlTextboxFormName.Text;
            saveForm.TITLE = BaseControlTextboxFormTitle.Text;
            saveForm.SYSTEM_WIDE_FLAG = CheckboxSystemWideFlag.Checked;
            HiddenFieldSystemWide.Value = CheckboxSystemWideFlag.Checked ? "yes" : "no";
            saveForm.EDITABLE_FLAG = true;
            saveForm.ACTIVE_FLAG = false;

            try
            {
                formId = toolManager.SaveForm(User.Identity.Name, formId, saveForm);

                if (formId > 0)
                {
                    HiddenFieldFormId.Value = formId.ToString();
                    LoadBaseControls();
                    LoadControlsFromObject(formId);
                }
                else
                {
                    LoadBaseControls();
                }
            }
            catch
            {
                LoadBaseControls();
            }

            return formId;
        }

        private int SubmitQuestionGroupAsComplete()
        {
            int formId = Helpers.GetIntFromString(HiddenFieldFormId.Value);

            TOOL_FORM_DTO saveForm = toolManager.GetFormById(formId);
            saveForm.EDITABLE_FLAG = false;
            saveForm.ACTIVE_FLAG = true;

            try
            {
                formId = toolManager.SaveForm(User.Identity.Name, formId, saveForm);
                
                if (formId > 0)
                {
                    HiddenFieldFormId.Value = formId.ToString();
                    LoadBaseControls();
                    LoadControlsFromObject(formId);
                }
                else
                {
                    LoadBaseControls();
                }
            }
            catch
            {
                LoadBaseControls();
            }

            return formId;
        }

        public void LoadControlsFromObject(int formId)
        {
            if (formId > 0)
            {
                UserSession.BprFormId = formId.ToString();
                var form = toolManager.GetFormById(formId);
                if (form != null)
                {
                    BaseControlTextboxFormName.Text = form.NAME;
                    BaseControlTextboxFormTitle.Text = form.TITLE;
                    CheckboxSystemWideFlag.Checked = form.SYSTEM_WIDE_FLAG;
                    HiddenFieldSystemWide.Value = form.SYSTEM_WIDE_FLAG ? "yes" : "no";
                    PanelEditFormQuestion.Visible = true;
                    PanelFormQuestions.Visible = (form.TOOL_FORM_QUESTIONs.Count() > 0);
                    GridViewFormQuestions.DataSource = toolManager.GetQuestionsByFormId(Helpers.GetIntFromString(HiddenFieldFormId.Value));
                    GridViewFormQuestions.DataBind();
                    LinkButtonQuestionGroupPreview.PostBackUrl = "ToolQuestionGroupPreview.aspx?id=" + form.TOOL_FORM_ID.ToString();
                    LinkButtonQuestionGroupPreview.Visible = (form.TOOL_FORM_QUESTIONs.Count() > 0);
                    LinkButtonQuestionGroupPreviewBottom.PostBackUrl = "ToolQuestionGroupPreview.aspx?id=" + form.TOOL_FORM_ID.ToString();
                    LinkButtonQuestionGroupPreviewBottom.Visible = (form.TOOL_FORM_QUESTIONs.Count() > 0);
                }
            }
            else
            {
                UserSession.BprFormId = string.Empty;
                PanelEditFormQuestion.Visible = false;
                LinkButtonQuestionGroupPreview.Visible = false;
                LinkButtonQuestionGroupPreviewBottom.Visible = false;
            }
        }

        private void LoadBaseControls()
        {
            foreach (STD_GUI_CONTROLS dbItem in ServiceInterfaceManager.STD_GUI_CONTROLS_GetByCategory(User.Identity.Name, 16, "AHOBPR_TOOL_QUESTION_GROUP"))
            {
                Control userControl = this.PanelEditQuestionGroup.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    if (dbItem.BASE_CONTROL_TYPE == (int)VIRP.AHOBPR.BLL.AhobprBaseControlType.TextBox)
                    {
                        controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                        baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, true, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION, dbItem.REQUIRED);
                    }
                    else if (dbItem.BASE_CONTROL_TYPE == (int)VIRP.AHOBPR.BLL.AhobprBaseControlType.CheckBox)
                    {
                        controls_BaseControlCheckBox baseControl = (controls_BaseControlCheckBox)userControl;
                        baseControl.LoadControlsFromObject(false, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, true);
                    }
                }
            }
        }

        public override string TopMenuName()
        {
            return "Tool";
        }

        public override string MenuItemName()
        {
            return "Question Group List";
        }

        public override string AppObjectCode()
        {
            return "AHOBPR TOOL";
        }

        protected void ButtonSaveQuestionGroup_Click(object sender, EventArgs e)
        {
            try
            {
                int formId = SaveQuestionGroup();
                if (formId > 0)
                {
                    ButtonSubmitQuestionGroup.Enabled = true;
                    Alert.ShowSaveSuccess();
                }
                else
                {
                    Alert.ShowSaveFailed();
                }
            }
            catch
            {
                Alert.ShowSaveFailed();
            }
        }

        protected void GridViewFormQuestions_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            GridViewFormQuestions.PageIndex = e.NewPageIndex;
            int formId = Convert.ToInt32(HiddenFieldFormId.Value);

            if (formId != 0)
            {
                LoadControlsFromObject(formId);
            }
        }

        protected void GridViewPageSizeDdlChanged(Object sender, EventArgs e)
        {
            GridViewFormQuestions.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
            int formId = Convert.ToInt32(HiddenFieldFormId.Value);

            if (formId != 0)
            {
                LoadControlsFromObject(formId);
            }
        }

        protected void GridViewPageSizeDdlChanged2(Object sender, EventArgs e)
        {
            GridViewQuestions.PageSize = int.Parse(gridViewPageSizeDdl2.SelectedValue);
        }
    }
}